<?php

namespace Inside\Statistics\Http\Controllers\Exports;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Inside\Content\Facades\ContentHelper;
use Inside\Statistics\Exports\AuthenticationStatsExport;
use Inside\Statistics\Listeners\NotifyUserOfCompletedStatisticExport;

class ExportAuthenticationStats
{
    public function __invoke(string $format, Request $request): JsonResponse
    {
        if (! in_array($format, config('statistics.allowed_export_formats', []))) {
            $format = 'csv';
        }
        $excelPath = 'statistics/'.now()->format('YmdHis').'_'.Str::random(8).'_export.'.$format;
        (new AuthenticationStatsExport(ContentHelper::extractFiltersInputFromRequest($request)))
            ->queue($excelPath, 'protected')
            ->chain([
                new NotifyUserOfCompletedStatisticExport($request->user(), $excelPath, 'protected'),
            ])
            ->allOnQueue(get_low_priority_queue_name());

        return response()->json(
            [
                'success' => true,
            ]
        );
    }
}
