<?php

namespace Inside\Statistics\Http\Controllers\Charts;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Inside\Authentication\Models\User;
use Inside\Content\Facades\ContentHelper;
use Inside\Statistics\Contracts\Statistic;

class UserVisitData
{
    public function __invoke(string $type, string $userId, Request $request, Statistic $statistic): JsonResponse
    {
        $user = User::findOrFail($userId);

        return response()->json(
            $statistic->getChartUserVisitsData($type, $user, ContentHelper::extractFiltersInputFromRequest($request))
        );
    }
}
