<?php

namespace Inside\Statistics\Exports;

use Illuminate\Support\Collection;
use Inside\Content\Models\Contents\Users;
use Inside\Database\Eloquent\Builder;
use Inside\Statistics\Repositories\StatisticsBetaRepository;

class UserViewedContentStatsExport extends AbstractStatsExport
{
    /**
     * @var StatisticsBetaRepository
     */
    protected StatisticsBetaRepository $repository;

    public function __construct(
        protected Users $user,
        protected string $contentType,
        protected array $filters,
        protected ?string $search
    ) {
        parent::__construct('contents');

        $this->repository = new StatisticsBetaRepository();
    }

    public function query(): Builder
    {
        return $this->repository->getUserViewedContentList(
            $this->user,
            $this->contentType,
            $this->filters,
            $this->search
        );
    }

    public function map($row): array
    {
        $row = $row->content;
        $mapped = [];
        foreach (array_keys(config('statistics.export.'.$this->type.'.headers', [])) as $key) {
            $value = '';
            if (isset($row->{$key})) {
                if (is_string($row->{$key})) {
                    $value = $row->{$key};
                } elseif ($row->{$key} instanceof Collection) {
                    $value = implode(', ', $row->{$key}->pluck('title')->toArray());
                }
            }

            $callback = config('statistics.export.'.$this->type.'.presenters.'.$key);

            if (! is_null($callback) && is_callable($callback)) {
                $value = $callback($value, $row);
            }

            $mapped[] = $value;
        }

        return $mapped;
    }
}
