<?php

namespace Inside\Statistics\Exports;

use Illuminate\Support\Facades\DB;
use Inside\Authentication\Models\User;
use Inside\Content\Facades\ContentHelper;
use Inside\Content\Models\Content;
use Inside\Content\Models\Contents\Users;
use Inside\Database\Eloquent\Builder;
use Inside\Statistics\Facades\Stats;
use Inside\Statistics\Repositories\StatisticsBetaRepository;
use Inside\Support\Str;

class ContentReadersStatsExport extends AbstractStatsExport
{
    protected StatisticsBetaRepository $repository;

    public function __construct(
        protected Content $content,
        protected array $filters,
        protected ?string $search
    ) {
        parent::__construct('users');

        $this->repository = new StatisticsBetaRepository();
    }

    public function query(): Builder
    {
        return $this->repository->getContentReadersQuery($this->content, $this->filters, $this->search);
    }

    public function map($row): array
    {
        $row = $row->user ?? $row;

        return parent::map($row); // TODO: Change the autogenerated stub
    }
}
