<?php

namespace Inside\Statistics\Contracts;

use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Illuminate\Contracts\Pagination\Paginator;
use Illuminate\Database\Eloquent\Collection;
use Inside\Authentication\Models\User;
use Inside\Content\Models\Content;
use Inside\Database\Eloquent\Builder;

interface Statistic
{
    public function getAuthenticationStats(array $filters = []): mixed;

    public function getUserVisitStatistics(string $type, array $filters = [], ?string $search = null): mixed;

    public function getContentStatistics(string $type, array $filters = []): Paginator|Collection|LengthAwarePaginator|array;

    public function countContent(array $types = [], array $filters = []): array;

    public function getSocialStats(array $filters = []): array;

    public function getTypes(): \Illuminate\Support\Collection;

    public function getUserViewedContentList(User $user, array $types, array $filters, ?string $search = null): mixed;

    public function getContentReaders(Content $content, array $filters, ?string $search = null): Paginator|Collection|LengthAwarePaginator|array;

    public function getChartAuthenticationsData(array $filters = []): array;

    public function getChartGlobalData(array $filters = []): array;

    public function getChartUserVisitsData(string $type, User $user, array $filters = []): array;

    public function getChartVisitsData(string $type, array $filters = []): array;
}
