<?php

use Faker\Factory as Faker;
use Illuminate\Database\Seeder;
use Inside\Authentication\Models\User;
use Inside\Content\Models\Contents\News;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;
use Inside\Reaction\Exceptions\ReactionNotFoundException;
use Inside\Statistics\Events\AnalyticLogEvent;
use Symfony\Component\Console\Helper\ProgressBar;

class CreateFakeUsersNavigationSeeder extends Seeder
{
    /**
     * @return void
     * @throws ReactionNotFoundException
     */
    public function run(): void
    {
        $output = $this->command;
        $output->line('Démarrage du seeder');
        $size = intval($output->ask('how many users to be test ?', '1000'));
        $bridge = new BridgeContent();
        $progressBar = new ProgressBar($output->getOutput(), $size);
        $progressBar->start();
        $faker = Faker::create('fr_FR');
        $users = Users::inRandomOrder()->take($size)->get();
        $reactionService = new Inside\Reaction\Services\ReactionService();

        foreach ($users as $user) {
            $seenPages = $faker->randomDigit;
            if ($seenPages > 0) {
                $authUser = User::find($user->uuid);
                $news = News::inRandomOrder()->whereStatus(true)->take($seenPages)->get();
                foreach ($news as $item) {
                    event(
                        new AnalyticLogEvent(
                            'view',
                            $item,
                            $authUser,
                            $faker->dateTimeBetween('-1 year')->format('Y-m-d H:i:s')
                        )
                    );

                    if ($faker->boolean(60)) {
                        $reactionService->create(
                            [
                                'type' => 'like',
                                'reactionable_type' => type_to_class('news'),
                                'reactionable_uuid' => $item->uuid,
                                'user_uuid' => $user->uuid,
                                'langcode' => $item->langcode,
                            ]
                        );
                    }
                    if ($faker->boolean(30)) {
                        $bridge->contentInsert(
                            'comments',
                            [
                                'bundle' => 'news',
                                'body' => $faker->realText($faker->biasedNumberBetween(30, 60)),
                                'langcode' => $item->langcode,
                                'status' => true,
                                'news' => [
                                    $item->uuid,
                                ],
                                'uid' => $user->uuid,
                            ]
                        );
                    }
                }
            }
            $progressBar->advance();
        }
        $progressBar->finish();
    }
}
