<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class AddPublishedAtColumnToContentStatisticsTable extends Migration
{
    public function up(): void
    {
        Schema::table('content_statistics', function (Blueprint $table) {
            $table->timestamp('published_at')->after('updated_at');
        });
        DB::table('content_statistics')->update(['published_at' => DB::raw('created_at')]);
    }

    public function down(): void
    {
        Schema::table('content_statistics', function (Blueprint $table) {
            $table->dropColumn('published_at');
        });
    }
}
