<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUserStatisticsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        Schema::create(
            'user_statistics',
            function (Blueprint $table) {
                $table->increments('id');
                $table->uuid('uuid');
                $table->string('type');
                $table->integer('visits')->default(0);
                $table->integer('unique_visits')->default(0);
                $table->date('date');
                $table->unique(['uuid', 'type', 'date']);
            }
        );
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
        Schema::dropIfExists('user_statistics');
    }
}
