<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Inside\Content\Models\Contents\Comments;
use Inside\Statistics\Models\Statistic;

class RetroComments extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        Comments::each(
            function ($comment) {
                // Find content parent
                $relatedContents = DB::table('inside_pivots')->where('parent_type', Comments::class)->where(
                    'parent_uuid',
                    $comment->uuid
                )->where('parent_langcode', $comment->langcode)->where(
                    'related_type',
                    '<>',
                    Comments::class
                )->get();
                if ($relatedContents->count() == 1) {
                    $relatedContent = $relatedContents->first();
                    $relatedType = class_to_type($relatedContent->related_type);
                    if (array_key_exists($relatedType, config('statistics.types'))) {
                        if (! Statistic::where('type', 'comment')->where('statisticable_uuid', $comment->uuid)->where(
                            'statisticable_type',
                            Comments::class
                        )->exists()
                        ) {
                            Statistic::create(
                                [
                                    'type'               => 'comment',
                                    'user_uuid'          => $comment->author,
                                    'langcode'           => $comment->langcode,
                                    'statisticable_uuid' => $comment->uuid,
                                    'statisticable_type' => Comments::class,
                                    'created_at'         => $comment->created_at,
                                    'updated_at'         => $comment->updated_at,
                                ]
                            );
                        }
                    }
                }
            }
        );
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
        Schema::drop('authentication_statistics');
    }
}
