<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;
use Inside\Reaction\Models\Reaction;
use Inside\Statistics\Models\Statistic;

class RetroLikeReactions extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        Reaction::where('type', 'like')->each(
            function (Reaction $reaction) {
                $type = class_to_type($reaction->reactionable_type);
                if (array_key_exists($type, config('statistics.types'))) {
                    if (! Statistic::where('statisticable_uuid', $reaction->id)->where(
                        'statisticable_type',
                        Reaction::class
                    )->where('user_uuid', $reaction->user_uuid)->exists()
                    ) {
                        Statistic::create(
                            [
                                'type'               => 'reaction.like',
                                'user_uuid'          => $reaction->user_uuid,
                                'langcode'           => $reaction->langcode,
                                'statisticable_uuid' => $reaction->id,
                                'statisticable_type' => Reaction::class,
                                'created_at'         => $reaction->created_at,
                                'updated_at'         => $reaction->updated_at,
                            ]
                        );
                    }
                }
            }
        );
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
        Schema::drop('authentication_statistics');
    }
}
