<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateContentsStatistics extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        Schema::create(
            'content_statistics',
            function (Blueprint $table) {
                $table->increments('id');
                $table->string('title');
                $table->uuid('uuid');
                $table->string('type');
                $table->boolean('status')->defaut(false);
                $table->string('slug')->nullable();
                $table->uuid('category_uuid')->nullable();
                $table->string('category_title')->nullable();
                $table->char('langcode', 2)->nullable()->index();
                $table->integer('visits')->default(1);
                $table->integer('unique_visits')->default(1);
                $table->integer('likes')->default(0);
                $table->integer('comments')->default(0);
                $table->dateTime('created_at');
                $table->dateTime('updated_at');
                $table->date('date');
                $table->unique(['uuid', 'type', 'date']);
            }
        );
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
        Schema::drop('content_statistics');
    }
}
