<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterStatisticsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        Schema::table(
            'inside_statistics',
            function (Blueprint $table) {
                $table->index('created_at', 'statistics_created_at_index');
                $table->index('statisticable_type', 'statistics_statisticable_type_index');
                $table->index('statisticable_uuid', 'statistics_statisticable_uuid_index');
                $table->index(['statisticable_uuid', 'statisticable_type'], 'statistics_statisticable_index');
                $table->index(
                    ['statisticable_uuid', 'statisticable_type', 'langcode'],
                    'statistics_statisticable_lang_index'
                );
            }
        );
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
        Schema::dropIfExists('inside_statistics');
    }
}
