<?php

namespace Inside\Slug\Services;

use Inside\Content\Models\Content;
use Inside\Slug\Contracts\ContentUrlGenerator;

class ContentUrlGeneratorService implements ContentUrlGenerator
{
    public function generateUrl(?Content $content): ?string
    {
        if ($content === null) {
            return null;
        }

        if (! config('slug.magic_urls')) {
            return $content->slug[0] ?? null;
        }

        return "external-url/{$content->content_type}/{$content->uuid}";
    }
}
