<?php

namespace Inside\Slug\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;

/**
 * @property-read string $uuid
 * @property ?string $type
 * @property string $slug
 *
 * @method static Builder|Slug whereSlug($value)
 * @mixin Builder
 * @mixin \Eloquent
 */
class Slug extends Model
{
    /**
     * @var string
     */
    protected $table = 'inside_slugs';

    /**
     * @var array
     */
    protected $fillable = ['type', 'uuid', 'slug', 'langcode'];

    /**
     * @var array
     */
    protected $guarded = [];

    /**
     * @var bool
     */
    public $timestamps = false;
}
