<?php

namespace Inside\Slug\Console\Commands;

use Illuminate\Console\Command;
use Inside\Content\Models\Model;
use Inside\Slug\Models\Slug;
use Symfony\Component\Console\Formatter\OutputFormatterStyle;

class RebuildCommand extends Command
{
    /**
     * @var string
     */
    protected $signature = 'slug:rebuild {--force}';

    /**
     * @var string
     */
    protected $description = 'Rebuild all slugs';

    /**
     * @return void
     */
    public function handle(): void
    {
        $force = (bool) $this->option('force');

        $models = Model::all();
        $style = new OutputFormatterStyle('yellow', 'blue', ['bold']);
        $this->output->getFormatter()->setStyle('bigblue', $style);
        $this->output->writeln('<bigblue>'.\Inside::getCommandInfo().'</bigblue>');
        $this->line('');

        if (! $force && ! $this->confirm('Are you sure to continue ? Some link may be broken after having rebuild slugs')) {
            return;
        }

        // Remove old slug
        Slug::truncate();

        foreach ($models as $model) {
            $options = $model->options;

            if (! isset($options['aliasable']) || ! $options['aliasable']) {
                continue;
            }

            if (isset($options['searchable']) && $options['searchable']) {
                // Do not sync with search index ( slug is not used their )
                call_user_func($model->model.'::withoutSyncingToSearch', function () use ($model) {
                    $entities = call_user_func($model->model.'::get');
                    $entities->each->save();
                });
                continue;
            }

            $entities = call_user_func($model->model.'::get');
            $entities->each->save();
        }
    }
}
