<?php

return [
    /**
     * What attributes do we use to build the slug?
     * This can be a single field, like "name" which will build a slug from:
     *
     *     $model->name;
     *
     * Or it can be an array of fields, like ("name", "company"), which builds a slug from:
     *
     *     $model->name . ' ' . $model->company;
     */
    'source' => null,
    /**
     * What attributes do we use to prefix the slug?
     * This can be a single relation field, like "category" which will build a slug from:
     *
     *      $model->category->slug . '/' . $model->name;
     *
     * Or it can be an array of relation field like ("category", "parent"), which builds multiple slug like:
     *
     *      $model->category->slug . '/ . $model->name;
     *      $model->parent->slug . '/ . $model->name;
     *
     * If parents are many to many relations, this will recurse on all its parents.
     */
    'parent' => null,
    /**
     * The maximum length of a generated slug.
     */
    'maxLength' => 255,
    /**
     * If you are setting a maximum length on your slugs, you may not want the
     * truncated string to split a word in half.  The default setting of "true"
     * will ensure this, e.g. with a maxLength of 12:
     *
     *   "my source string" -> "my-source"
     */
    'maxLengthKeepWords' => true,
    /**
     * Separator to use when generating slugs.
     */
    'separator' => '-',
];
