<?php

use Inside\Settings\Contracts\SettingService;

if (! function_exists('setting')) {
    /**
     * @param string $group
     * @param array|string $key
     * @param array|string $default
     * @return Laravel\Lumen\Application|mixed|null
     */
    function setting(string $group, $key = null, $default = null)
    {
        try {
            $setting = app(SettingService::class);

            if (is_array($key)) {
                $setting->set($group, $key);
            } elseif (! is_null($key)) {
                return $setting->get($group, $key, $default);
            }

            return $setting;
        } catch (Exception $e) {
            return $default;
        }
    }
}
