<?php

namespace Inside\Settings\Services;

use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Cache;
use Inside\Facades\Http;

class GoogleFontsService
{
    public function __construct(
        private string $apiUrl,
        private string $apiKey,
        private int $cacheTtl,
        private string $cacheTag
    ) {
    }

    public function getFonts(): JsonResponse
    {
        $cachedResponse = Cache::tags([$this->cacheTag])->get($this->apiUrl);

        if ($cachedResponse) {
            return response()->json($cachedResponse);
        }

        $response = Http::get($this->apiUrl, [
            'key' => $this->apiKey,
            'capability' => 'WOFF2',
        ]);

        if ($response->successful()) {
            $json = [];
            $json['items'] = collect($response->json()['items'])->filter(function ($font) {
                return in_array($font['category'], ['sans-serif', 'serif']);
            })->toArray();
            Cache::tags([$this->cacheTag])->put(
                $this->apiUrl,
                $json,
                $this->cacheTtl
            );

            return response()->json($json);
        }

        return response()->json([
            'error' => 'API is unavailable',
        ], $response->status());
    }
}
