<?php

namespace Inside\Settings\Providers;

use Inside\Settings\Console\AuditCommand;
use Inside\Settings\Contracts\SettingService;
use Inside\Settings\Models\Setting;
use Inside\Settings\Observers\ColorChangedObserver;
use Inside\Settings\Observers\FaviconChangedObserver;
use Inside\Settings\Observers\SendingEmailObserver;
use Inside\Settings\Observers\SettingObserver;
use Inside\Settings\Services\GoogleFontsService;
use Inside\Settings\Services\SettingStore;
use Inside\Support\EventServiceProvider;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

/**
 * Class SettingsServiceProvider
 */
class SettingsServiceProvider extends EventServiceProvider
{
    public array $singletons = [
        SettingService::class => SettingStore::class,
    ];

    protected array $commands = [
        AuditCommand::class,
    ];

    public function boot(): void
    {
        parent::boot();

        Setting::observe(ColorChangedObserver::class);
        Setting::observe(SettingObserver::class);
        Setting::observe(SendingEmailObserver::class);
        Setting::observe(FaviconChangedObserver::class);
    }

    /**
     * @throws ContainerExceptionInterface
     * @throws NotFoundExceptionInterface
     */
    public function register(): void
    {
        $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/authentication.php', 'authentication');
        $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/google_fonts.php', 'google_fonts');
        $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/audit.php', 'audit');
        $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/secure_settings.php', 'secure_settings');

        $this->app->singleton(
            GoogleFontsService::class,
            function () {
                return new GoogleFontsService(
                    config('google_fonts.api_url'),
                    config('google_fonts.api_key'),
                    config('google_fonts.cache_ttl'),
                    config('google_fonts.cache_tag')
                );
            });
    }
}
