<?php

namespace Inside\Settings\Observers;

use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Log;
use Inside\Services\FaviconsGeneratorService;
use Inside\Settings\Models\Setting;

class FaviconChangedObserver
{
    public function updated(Setting $setting): void
    {
        if ($setting->key === 'favicon' && $setting->group === 'general' && $setting->isDirty('value')) {
            if (is_string($setting->value) && str($setting->value)->is('chunks/**')) {
                Log::info('Generating favicons from chunks');
                $files = FaviconsGeneratorService::generate(storage_path(sprintf('app/%s', $setting->value)));
            } elseif (is_null($setting->value)) {
                Log::info('Generating default favicons');
                $files = FaviconsGeneratorService::generate(FaviconsGeneratorService::DEFAULT_FAVICON);
            } else {
                return;
            }

            $setting->unsetEventDispatcher();
            $setting->update(['value' => 'assets/favicons/original.png']);
        }
    }
}
