<?php

namespace Inside\Settings\Observers;

use Illuminate\Support\Facades\DB;
use Inside\Jobs\Queue\RestartQueue;
use Inside\Settings\Models\Setting;

class ColorChangedObserver
{
    public function updated(Setting $setting): void
    {
        if (in_array($setting->key, ['color_primary', 'color_secondary'])) {
            RestartQueue::dispatch();
        }

        if ($setting->key === 'color_primary') {
            $this->updateFieldsDefault($setting->value);
            $this->updateSectionButton($setting->value);
        }
    }

    private function updateFieldsDefault(string $color): void
    {
        $fieldNames = ['button_color', 'color'];

        $fields = DB::table('inside_fields')
            ->whereIn('name', $fieldNames)
            ->select('id', 'name', 'options')
            ->get();

        foreach ($fields as $field) {
            if (! is_string($field->options)) {
                continue;
            }

            $options = json_decode($field->options, true);
            if (! is_array($options)) {
                continue;
            }

            $options['default'] = $color;

            DB::table('inside_fields')
                ->where('id', $field->id)
                ->update(['options' => json_encode($options)]);
        }
    }

    private function updateSectionButton(string $color): void
    {
        DB::table('inside_section_button')
            ->update(['button_color' => $color]);
    }
}
