<?php

namespace Inside\Settings\Audit\Tests\ContentTypes;

use Illuminate\Support\Str;
use Inside\Content\Facades\Schema;
use Inside\Settings\Audit\Tests\BaseTest;

class GlobalSearchableContentTypesTest extends BaseTest
{
    public static function check(): bool
    {
        $typesGlobalSearchable = collect(Schema::getContentTypes())
            ->reject(fn ($type) => Str::endsWith($type, '_menus') || in_array($type, ['comments', 'users']))
            ->filter(fn ($type) => Schema::getSchemaInformation($type)['options']['global_searchable'] === true);

        if ($typesGlobalSearchable->isNotEmpty()) {
            self::setMessage(__('audit.content_types.global_searchable.message').implode(', ', $typesGlobalSearchable->toArray()));

            return true;
        }

        self::setMessage(__('audit.content_types.global_searchable.error_message'));

        return false;
    }

    public static function getLabel(): string
    {
        return __('audit.content_types.global_searchable.title');
    }
}
