<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Settings\Models\Setting;

final class UpdateAiModuleOptions extends Migration
{
    public function up(): void
    {
        $apiKey = Setting::where(['group' => 'ai', 'key' => 'api_key'])->first()?->value;
        if (! empty($apiKey)) {
            Setting::updateOrCreate(['key' => 'openai_api_key', 'group' => 'ai'], ['value' => $apiKey]);
            Setting::where(['key' => 'api_key', 'group' => 'ai'])->delete();
        }

        $defaultModel = Setting::where(['group' => 'ai', 'key' => 'default_model'])->first()?->value;
        if (! empty($apiKey)) {
            Setting::updateOrCreate(['key' => 'openai_default_model', 'group' => 'ai'], ['value' => $defaultModel]);
            Setting::where(['key' => 'default_model', 'group' => 'ai'])->delete();
        }
    }
}
