<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Settings\Models\Setting;

final class MultilingualBtnOption extends Migration
{
    public function up(): void
    {
        $defaultValue = match (config('app.code')) {
            'prae' => 'navbar',
            'nckl' => 'not-displayed',
            default => 'footer',
        };
        Setting::updateOrCreate(['key' => 'language_button_placement', 'group' => 'multilingual'], ['value' => $defaultValue]);
    }
}
