<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Settings\Models\Setting;

final class UpdateLoginPageOption extends Migration
{
    public function up(): void
    {
        Setting::where(['key' => 'redirection_page_enabled', 'group' => 'logoutpage'])->delete();

        $defaultValue = ! is_null(config('right')) ? true : null;
        Setting::updateOrCreate(['key' => 'redirection_page_enabled', 'group' => 'loginpage'], ['value' => $defaultValue]);
    }
}
