<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;

final class AddIaModuleOptions extends Migration
{
    public function up(): void
    {
        $defaultProvider = config('ai.default_provider') ?? null;
        $defaultModel = config('ai.default_model') ?? null;
        $prompts = config('ai.all_prompts') ?? [];

        setting('ai', ['default_provider' => $defaultProvider]);
        setting('ai', ['default_model' => $defaultModel]);

        foreach ($prompts as $language => $prompt) {
            setting('ai', ['system_role_'.$language => $prompt['original']]);
            setting('ai', ['prompt_format_'.$language => $prompt['formatting']]);
            foreach (array_keys(config('ai.prompts.actions')) as $action) {
                setting('ai', ['action_'.$action.'_'.$language => $prompt[$action]]);
            }
        }
    }
}
