<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Settings\Models\Setting;

final class AddInsideRadiusDefaultValue extends Migration
{
    public function up(): void
    {
        Setting::updateOrCreate(['key' => 'radius_style', 'group' => 'general'], ['value' => 'squared']);
    }

    public function down(): void
    {
        Setting::where(['key' => 'radius_style', 'group' => 'general'])->delete();
    }
}
