<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Log;
use Inside\Settings\Models\Setting;

final class UpdateIdentityGroupName extends Migration
{
    public function up(): void
    {
        $groupKeyMapping = [
            'meta_title' => 'general',
            'color_primary' => 'general',
            'color_secondary' => 'general',
            'plannedMark_general' => 'general',
        ];

        collect($groupKeyMapping)->each(function ($group, $name) {
            try {
                Setting::updateOrCreate(
                    ['group' => 'identity', 'key' => $name],
                    ['group' => $group]
                );
            } catch (\Exception $e) {
                Log::error('Update settings : '.$e->getMessage());
            }
        });
    }
}
