<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Settings\Models\Setting;

final class AddSettingShowIntroInContent extends Migration
{
    public function up(): void
    {
        $bridgeContentType = new BridgeContentType();

        if (! InsideSchema::hasModel('news')) {
            return;
        }

        Setting::firstOrCreate(
            attributes: ['group' => 'news', 'key' => 'show_intro_in_content'],
            values: ['value' => null]
        );
    }
}
