<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Settings\Models\Setting;

final class CreateSettingsForAgenda extends Migration
{
    public function up(): void
    {
        Setting::updateOrCreate(['key' => 'dark_title', 'group' => 'agenda'], ['value' => null]);
        Setting::updateOrCreate(['key' => 'title_agenda', 'group' => 'agenda'], ['value' => null]);
    }

    public function down(): void
    {
        Setting::where(['key' => 'dark_title', 'group' => 'agenda'])->delete();
        Setting::where(['key' => 'title_agenda', 'group' => 'agenda'])->delete();
    }
}
