<?php

declare(strict_types=1);
use Illuminate\Database\Migrations\Migration;
use Inside\Settings\Models\Setting;

final class AddFieldMenuFontWeightInSettings extends Migration
{
    public function up(): void
    {
        Setting::updateOrCreate(
            ['key' => 'menu_font_weight', 'group' => 'general'],
            ['value' => null]
        );
    }

    public function down(): void
    {
        Setting::where(
            ['key' => 'menu_font_weight', 'group' => 'general']
        )->delete();
    }
}
