<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Settings\Models\Setting;

final class AddShowNewsletterButton extends Migration
{
    public function up(): void
    {
        Setting::updateOrCreate(['key' => 'show_newsletter_button', 'group' => 'newsletter'], ['value' => true]);
    }

    public function down(): void
    {
        Setting::where(['key' => 'show_newsletter_button', 'group' => 'newsletter'])->delete();
    }
}
