<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Settings\Models\Setting;

final class ChangeFalseValuesToNull extends Migration
{
    public function up(): void
    {
        Setting::query()
            ->where('key', '!=', 'matomo_analytical')
            ->where('value', '0')
            ->each(fn (Setting $setting) => $setting->update(['value' => null]));
    }
}
