<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Settings\Models\Setting;

final class AddFolderColorGedSettings extends Migration
{
    public function up(): void
    {
        $trueValueAppCodes = [
            'fare',
            'scea',
            'demo',
            'syct',
            'duva',
            'ageo',
            'afp2',
        ];

        $value = in_array(config('app.code'), $trueValueAppCodes) ?: null;

        Setting::firstOrCreate(['key' => 'folder_color_ged', 'group' => 'ged'], ['value' => $value]);
    }

    public function down(): void
    {
        Setting::where(['key' => 'folder_color_ged', 'group' => 'ged'])->delete();
    }
}
