<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Settings\Models\Setting;

final class UpdatePlannedMarkGeneralSetting extends Migration
{
    public function up(): void
    {
        Setting::where(['key' => 'plannedMark_general', 'group' => 'general'])->delete();
        Setting::firstOrCreate(['key' => 'plannedMark_general', 'group' => 'programmed-content'], ['value' => '🟠']);
    }

    public function down(): void
    {
        Setting::where(['key' => 'plannedMark_general', 'group' => 'programmed-content'])->delete();
    }
}
