<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

class FixAnalyticCodes extends Migration
{
    public function up(): void
    {
        $matomo = DB::table('inside_settings')->where('key', 'matomo_analytical')->first();

        if (! is_null($matomo) && ! is_null($matomo->value)) {
            return;
        }

        $codes = [];
        $types = ['ga', 'gtag', 'gtm'];

        $keys = ['general', 'analytical'];
        foreach ($types as $type) {
            $codes[$type] = [];

            foreach ($keys as $key) {
                $code = DB::table('inside_settings')->where('key', $type.'_'.$key)->first();

                if ($key === 'analytical') {
                    if (is_null($code)) {
                        DB::table('inside_settings')->insert([
                            'key' => $type.'_'.$key,
                            'value' => null,
                            'group' => 'analytical',
                        ]);
                    } else {
                        if (! is_null($code->value)) {
                            return;
                        }
                    }
                }

                $codes[$type][$key] = ! is_null($code) ? $code->value : null;
            }

            if ($codes[$type]['general'] !== $codes[$type]['analytical']) {
                DB::table('inside_settings')->where('key', $type.'_analytical')->update([
                    'value' => $codes[$type]['general'],
                ]);
            }
        }
    }

    public function down(): void
    {
    }
}
