<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class ChangeUniquenessInsideSettingsTable extends Migration
{
    public function up(): void
    {
        Schema::table('inside_settings', function (Blueprint $table) {
            $table->dropUnique('inside_settings_key_unique');
            $table->unique(['group', 'key']);
        });
    }

    public function down(): void
    {
        Schema::table('inside_settings', function (Blueprint $table) {
            $table->dropUnique('inside_settings_group_key_unique');
            $table->unique('key');
        });
    }
}
