<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateInsideSettingsTable extends Migration
{
    public function up(): void
    {
        Schema::create('inside_settings', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('key', 100)->unique();
            $table->text('value')->nullable();
            $table->string('group', 30)->index();
            $table->index(['key', 'group']);
        });
    }

    public function down(): void
    {
        Schema::drop('inside_settings');
    }
}
