<?php

use Illuminate\Support\Facades\Route;
use Inside\Search\Http\Controllers\AdvancedSearch;
use Inside\Search\Http\Controllers\GenericSearch;
use Inside\Search\Http\Controllers\HistoryDestroy;
use Inside\Search\Http\Controllers\HistoryIndex;
use Inside\Search\Http\Controllers\SearchableIndex;
use Inside\Search\Http\Controllers\SpecialSearch;

Route::group(
    [
        'prefix'     => 'api/v1',
        'middleware' => 'auth.api',
    ],
    function ($router) {
        $router->get('search', GenericSearch::class);
        $router->get('advanced/search', AdvancedSearch::class);
        $router->get('special/search', SpecialSearch::class);

        $router->get('searchable', SearchableIndex::class);

        $router->get('user/search/history', HistoryIndex::class);
        $router->delete('user/search/history/{id}', HistoryDestroy::class);
    }
);
