<?php

namespace Inside\Search\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Support\Carbon;
use Inside\Database\Eloquent\WithEnhancedBuilder;

/**
 * @method static \Inside\Database\Eloquent\Builder|\Inside\Search\Models\SearchHistory newModelQuery()
 * @method static \Inside\Database\Eloquent\Builder|\Inside\Search\Models\SearchHistory newQuery()
 * @method static \Inside\Database\Eloquent\Builder|\Inside\Search\Models\SearchHistory query()
 * @mixin \Illuminate\Database\Eloquent\Model
 * @mixin Builder
 * @mixin \Eloquent
 */
class SearchHistory extends Model
{
    use WithEnhancedBuilder;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'inside_search_history';

    /**
     * The attributes that are mass assignable.
     *
     * @var string[]
     */
    protected $fillable = [
        'text',
        'user_uuid',
        'langcode',
    ];

    /**
     * The date attributes
     *
     * @var string[]
     */
    protected $dates = ['last_searched_at'];

    /**
     * Casts the following attributes
     *
     * @var array
     */
    protected $casts = [
        'user_uuid'       => 'string',
        'last_searched_at' => 'timestamp',
    ];

    public Carbon $last_searched_at;

    /**
     * The table without the timestamps.
     *
     * @var bool
     */
    public $timestamps = false;

    public function user(): BelongsTo
    {
        return $this->belongsTo('Inside\Authentication\Models\User', 'user_uuid', 'uuid');
    }
}
