<?php

namespace Inside\Search\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Inside\Authentication\Models\User;
use Inside\Permission\Exceptions\AuthorizationException;
use Inside\Search\Models\SearchHistory;

class HistoryIndex extends Controller
{
    public function __invoke(Request $request): JsonResponse
    {
        /** @var ?User $me */
        $me = Auth::user();

        if (! inside_search_history_enabled() || ! $me) {
            throw new AuthorizationException('This action is unauthorized.');
        }

        return response()->json([
            'data' => $this->getSearchHistory($me),
        ]);
    }
}
