<?php

namespace Inside\Search\Http\Controllers;

use Illuminate\Database\Eloquent\Collection;
use Inside\Authentication\Models\User;
use Inside\Search\Models\SearchHistory;
use Laravel\Lumen\Routing\Controller as BaseController;
use OpenApi\Annotations as OA;

/**
 * Search controller
 *
 * @OA\Tag(name="Recherche",description="
# Introduction
Il s'agit du service de recherche d'Inside 2. Il permet de chercher dans n'importe quel type de contenu configuré comme *searchable*.
# Types de moteur de recherche
Selon l'installation, le moteur de recherche se base pour le moment sur un moteur interne en mysql et une table d'indexation spécifique ( inside-search-databse ) ou sur un moteur de recherche Solr externe ( inside-search-solr ).
# Paramètre en backoffice
Pour chaque type de contenu, il est possible d'indiquer si l'on souhaite indexer et chercher le contenu dudit type de contenu.
Pour chaque champ d'un type de contenu, il existe trois paramètres qui influent sur le moteur de recherche et sont regroupés dans un fieldset *Recherche*.
 * Le premier *searchable* indique si le champ de ce type de contenu sera indexé ( ne fait rien si le type de contenu
 * lui même n'est pas noté *searchable*). Le second *search_field_result* indique si le champ est retourné lors d'une
 * recherche indépendemment qu'il soit *searchable* ou non. Pour le cas particulier où le champ est une référence, si
 * le champ est indiqué comme *search_field_result*, il retournera les champs de la cible qui sont eux-même tagué
 * *search_field_result*. Enfin le dernier *searchable_filter* permet de filtrer directement dans le moteur de
 * recherche à l'aide d'un critère de type filtre.
 * ")
 *
 *
 * @category Class
 * @author   Maecia <contact@feldoe.net>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class Controller extends BaseController
{
    protected function getSearchHistory(User $user): Collection
    {
        return SearchHistory::where('user_uuid', $user->uuid) // @phpstan-ignore-line
            ->where('langcode', $user->langcode)
            ->orderBy('last_searched_at', 'desc')
            ->get();
    }
}
