<?php

namespace Inside\Search\Console;

use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Config;
use Inside;
use Inside\Content\Models\Field;
use Inside\Content\Models\Model;
use Inside\Search\Facades\Searchable;

/**
 * Class IndexCommand
 *
 * @category Class
 * @author   Maecia <contact@feldoe.net>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class StructureCommand extends Command
{
    /**
     * @var string
     */
    protected $name = 'structure:infos';

    /**
     * @var string
     */
    protected $signature = 'structure:infos';

    /**
     * @var string
     */
    protected $description = 'Show Searchable structure';

    /**
     * Handle index command
     *
     * @throws \Exception
     * @return void
     */
    public function handle(): void
    {
        $this->info(Inside::getCommandInfo());

        Artisan::call('cache:clear');

        // The whole structure
        $models = Model::all();

        foreach ($models as $model) {
            if (isset($model->options['searchable']) && $model->options['searchable']) {
                $this->comment('Structure for ['.$model->model.']');

                if (isset($model->options['searchable_important'])) {
                    $this->info('Important column ['.$model->options['searchable_important'].']');
                }

                $definitions = [];

                foreach ($model->fields as $field) {
                    if (isset($field->options['searchable']) && $field->options['searchable']) {
                        $definitions[] = [$field->name, $field->type, true];
                    }
                }

                $this->table(['Name', 'Type', 'Searchable'], $definitions);
            }
        }
    }
}
