<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSearchHistoryTable extends Migration
{
    public function up(): void
    {
        Schema::create('inside_search_history', function (Blueprint $table) {
            $table->BigIncrements('id');
            $table->uuid('user_uuid')->collate('utf8');
            $table->text('text');
            // last time the user searched for this word
            $table->timestamp('last_searched_at')->useCurrent();
            $table->char('langcode', 2);

            $table->foreign('user_uuid')
                ->references('uuid')->on('inside_content_users')
                ->onDelete('cascade');

            $table->index(['user_uuid', 'langcode']);
        });
    }

    public function down(): void
    {
    }
}
