<?php

use Illuminate\Support\Facades\Route;
use Inside\Reaction\Http\Controllers\Get;
use Inside\Reaction\Http\Controllers\Index;
use Inside\Reaction\Http\Controllers\IndexForUser;
use Inside\Reaction\Http\Controllers\Subscribe;
use Inside\Reaction\Http\Controllers\Unsubscribe;

Route::group(
    [
        'prefix'     => 'api/v1',
        'middleware' => 'auth.api',
    ],
    function ($router) {
        $router->get('reactions/{type}/{related}/{user}', Get::class);
        $router->get('users/reactions/{type}[/{user}]', IndexForUser::class);
        $router->get('reactions/{type}/{related}', Index::class);
        $router->post('reactions', Subscribe::class);
        $router->delete('reactions/{type}/{related}/{userUuid}[/{langcode}]', Unsubscribe::class);
    }
);
