<?php

namespace Inside\Reaction\Jobs;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Inside\Jobs\Job;
use Inside\Reaction\Models\Reaction;

class Cleanup extends Job
{
    public function handle(): void
    {
        $toDelete = [];
        Reaction::each(
            function ($reaction) use (&$toDelete) {
                try {
                    if ($reaction->reactionable === null
                        || $reaction->user === null
                    ) {
                        $toDelete[] = $reaction->id;
                    }
                } catch (\Exception $e) {
                    $toDelete[] = $reaction->id;
                    Log::debug('[Reaction::Cleanup] '.$e->getMessage());
                }
            }
        );

        Log::debug('[Reaction::Cleanup] '.count($toDelete).' reaction(s) to be deleted');
        foreach (array_chunk($toDelete, 1000) as $ids) {
            DB::table('inside_reactions')->whereIn('id', $ids)->delete();
        }
        Log::debug('[Reaction::Cleanup] DONE');
    }
}
