<?php

namespace Inside\Reaction\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Inside\Authentication\Models\User;
use Inside\Content\Facades\ContentHelper;
use Inside\Reaction\Facades\Reactions;

class IndexForUser extends Controller
{
    public function __invoke(Request $request, string $type, ?string $user = null): JsonResponse
    {
        if (is_null($user)) {
            /** @var User $authUser */
            $authUser = Auth::user();
            $user = $authUser->uuid;
        }
        $fields = ContentHelper::extractFieldsInputFromRequest($request);
        $filters = ContentHelper::extractFiltersInputFromRequest($request);
        Reactions::userList(
            $type,
            $user,
            $filters['limit'] ?? 0,
            $filters['langcode'] ?? null,
            $fields,
            $filters['reactionable_types'] ?? [],
            $filters['status'] ?? 1
        );

        return response()->json(Reactions::getFormatted());
    }
}
