<?php

namespace Inside\Reaction\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Inside\Content\Facades\ContentHelper;
use Inside\Reaction\Facades\Reactions;

class Get extends Controller
{
    public function __invoke(Request $request, string $type, string $related, string $user): JsonResponse
    {
        $fields = ContentHelper::extractFieldsInputFromRequest($request);
        $filters = ContentHelper::extractFiltersInputFromRequest($request);

        return response()->json(Reactions::get(
            type: $type,
            reactionableUuid: $related,
            user: $user,
            langcode: $filters['langcode'] ?? null,
            fields: $fields
        ));
    }
}
