<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddIndexReactionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table(
            'inside_reactions',
            function (Blueprint $table) {
                $table->dropColumn('status');
                $table->index(['reactionable_uuid', 'reactionable_type', 'langcode'], 'reactions_reactionable_index');
                $table->index(['reactionable_type'], 'reactions_reactionable_type_index');
            }
        );
    }
}
