<?php

namespace Inside\Permission\Models\Traits;

use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Support\Str;
use Inside\Permission\Models\Permission;

trait HasBackofficeEntriesAccess
{
    public function backofficeEntriesAccess(): HasMany
    {
        return $this->hasMany(Permission::class)->where('type', 'backoffice');
    }

    public function hasAccessToBackoffice(string $entry): bool
    {
        return $this->backofficeEntriesAccess()->pluck('action')->contains('access_'.Str::lower(trim($entry)));
    }
}
